/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepWorkObjectHistory;
import filenet.vw.api.VWWorkObject;
import java.util.Date;
import java.util.Vector;

public final class VWParticipantHistory
extends VWMLABase {
    public static final int STATUS_NULL = 0;
    public static final int STATUS_IN_PROGRESS = 1;
    public static final int STATUS_COMPLETED_NORMAL = 2;
    public static final int STATUS_COMPLETED_ABNORMAL = 3;
    public static final int STATUS_WO_FORCED_TO_DELETE = 4;
    public static final int STATUS_WO_FORCED_TO_TERMINATE = 5;
    public static final int STATUS_DELEGATED = 6;
    public static final int STATUS_REASSIGNED = 7;
    public static final int STATUS_RETURNED = 8;
    public static final int STATUS_OVERDUE = 9;
    public static final int STATUS_REMINDED = 10;
    public static final int STATUS_GOTO_SUBMAP = 11;
    public static final int STATUS_EXCEPTION = 12;
    VWStepWorkObjectHistory m_woHistory;
    double m_firstUniqueId = -1.0;
    double m_lastUniqueId = -1.0;
    Vector m_logElements = new Vector();
    VWLogElement m_reminderLog = null;
    VWLogElement m_overdueLog = null;
    protected String workObjectNumber;

    public static String _get_FILE_DATE() {
        return "$Date: 2009-10-30 19:56:56 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/1 $";
    }

    protected VWParticipantHistory(VWStepWorkObjectHistory woHistory) throws VWException {
        this.m_woHistory = woHistory;
    }

    void addLogElement(VWLogElement logElement) throws VWException {
        double uniqueId = logElement.getUniqueId();
        if (this.m_lastUniqueId == -1.0 || Double.compare(uniqueId, this.m_lastUniqueId) > 0) {
            this.m_lastUniqueId = uniqueId;
        }
        if (this.m_firstUniqueId == -1.0 || Double.compare(uniqueId, this.m_firstUniqueId) < 0) {
            this.m_firstUniqueId = uniqueId;
        }
        this.m_logElements.addElement(logElement);
        int eventType = logElement.getEventType();
        if (eventType == 172) {
            this.m_overdueLog = logElement;
        } else if (eventType == 174) {
            this.m_reminderLog = logElement;
        }
    }

    public String getComments() {
        VWLogElement logElement = (VWLogElement)this.m_logElements.lastElement();
        if (logElement != null) {
            try {
                Object obj = logElement.getFieldValue("F_Comment");
                if (obj instanceof String) {
                    return (String)obj;
                }
            }
            catch (VWException vWException) {
                // empty catch block
            }
        }
        return null;
    }

    public Date getCompletionDate() {
        VWLogElement logElement = (VWLogElement)this.m_logElements.lastElement();
        if (logElement != null) {
            try {
                int operationId = -1;
                Object obj = logElement.getFieldValue("F_OperationId");
                if (obj != null && obj instanceof Integer) {
                    operationId = (Integer)obj;
                }
                int eventType = logElement.getEventType();
                switch (eventType) {
                    case 100: 
                    case 125: 
                    case 140: 
                    case 190: 
                    case 200: 
                    case 360: 
                    case 370: 
                    case 382: 
                    case 384: 
                    case 386: 
                    case 407: 
                    case 500: {
                        return logElement.getTimeStamp();
                    }
                }
                if (operationId == 38) {
                    return logElement.getTimeStamp();
                }
            }
            catch (VWException vWException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getCompletionUser() {
        VWParticipant completionUserPx = this.getCompletionUserPx();
        if (completionUserPx != null) {
            return completionUserPx.getParticipantName();
        }
        return null;
    }

    public VWParticipant getCompletionUserPx() {
        VWLogElement logElement = (VWLogElement)this.m_logElements.lastElement();
        if (logElement != null) {
            try {
                int eventType = logElement.getEventType();
                switch (eventType) {
                    case 190: 
                    case 200: 
                    case 360: 
                    case 370: 
                    case 382: 
                    case 384: 
                    case 386: {
                        return logElement.getUserNamePx();
                    }
                    case 140: {
                        return this.getParticipantNamePx();
                    }
                }
            }
            catch (VWException vWException) {
                // empty catch block
            }
        }
        return null;
    }

    public Date getDateReceived() {
        VWLogElement logElement;
        if (this.m_logElements.size() > 0 && (logElement = (VWLogElement)this.m_logElements.firstElement()) != null) {
            try {
                return logElement.getTimeStamp();
            }
            catch (VWException vWException) {
                // empty catch block
            }
        }
        return null;
    }

    public int getBoundUserId() throws VWException {
        VWLogElement logElement;
        if (this.m_logElements.size() > 0 && (logElement = (VWLogElement)this.m_logElements.firstElement()) != null) {
            Object obj = null;
            obj = logElement.getEventType() == 140 ? logElement.getFieldValue("F_Originator") : logElement.getFieldValue("F_BoundUserId");
            if (obj instanceof VWParticipant) {
                return (int)((VWParticipant)obj).getUserId();
            }
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
        }
        return -1;
    }

    public String getUserName() throws VWException {
        VWParticipant userPx = this.getUserNamePx();
        if (userPx != null) {
            return userPx.getParticipantName();
        }
        return null;
    }

    public VWParticipant getUserNamePx() throws VWException {
        if (this.m_logElements.size() > 0) {
            if (this.getCompletionDate() == null) {
                return null;
            }
            VWLogElement logElement = (VWLogElement)this.m_logElements.lastElement();
            if (logElement != null) {
                Object obj = logElement.getFieldValue("F_UserId");
                if (obj instanceof VWParticipant) {
                    return (VWParticipant)obj;
                }
                if (obj instanceof Integer) {
                    long userId = ((Integer)obj).longValue();
                    if (userId == 0L) {
                        return null;
                    }
                    VWSession session = this.m_woHistory.getSession();
                    return session.convertIdToUserNamePx(userId);
                }
            }
        }
        return null;
    }

    public String getParticipantName() throws VWException {
        VWParticipant px = this.getParticipantNamePx();
        if (px != null) {
            return px.getParticipantName();
        }
        return null;
    }

    public VWParticipant getParticipantNamePx() throws VWException {
        if (this.m_logElements.size() > 0) {
            long boundUserId = this.getBoundUserId();
            if (boundUserId == 0L) {
                return null;
            }
            VWSession session = this.m_woHistory.getSession();
            VWParticipant result = session.convertIdToUserNamePx(boundUserId);
            return result;
        }
        return null;
    }

    public String getQueueName() throws VWException {
        VWLogElement logElement = (VWLogElement)this.m_logElements.firstElement();
        if (logElement != null) {
            return logElement.getQueueName();
        }
        return null;
    }

    public String getOperationName() throws VWException {
        VWLogElement logElement = (VWLogElement)this.m_logElements.firstElement();
        if (logElement != null) {
            return logElement.getOperationName();
        }
        return null;
    }

    public String getResponse() throws VWException {
        VWLogElement logElement = (VWLogElement)this.m_logElements.lastElement();
        if (logElement != null) {
            Object obj = logElement.getFieldValue("F_Response");
            if (obj instanceof VWParticipant) {
                return ((VWParticipant)obj).getParticipantName();
            }
            if (obj instanceof String) {
                return this.translateStr((String)obj);
            }
        }
        return null;
    }

    public int getStepStatus() throws VWException {
        VWLogElement logElement = (VWLogElement)this.m_logElements.lastElement();
        if (logElement != null) {
            int operationId = -1;
            Object obj = logElement.getFieldValue("F_OperationId");
            if (obj != null && obj instanceof Integer) {
                operationId = (Integer)obj;
            }
            int eventType = logElement.getEventType();
            switch (eventType) {
                case 140: {
                    return 2;
                }
                case 125: {
                    return 2;
                }
                case 360: {
                    return 2;
                }
                case 370: {
                    return 3;
                }
                case 382: {
                    return 6;
                }
                case 384: {
                    return 7;
                }
                case 386: {
                    return 8;
                }
                case 190: {
                    return 5;
                }
                case 200: {
                    return 4;
                }
                case 500: {
                    return 2;
                }
                case 100: {
                    if (operationId == 5) {
                        return 11;
                    }
                    if (!VWParticipantHistory.isSystemInstructionsOperation(operationId)) break;
                    return 2;
                }
                case 405: {
                    return 11;
                }
                case 407: {
                    return 2;
                }
                case 170: {
                    return 12;
                }
                default: {
                    if (operationId != 38) break;
                    return 2;
                }
            }
        }
        return 1;
    }

    public VWDataField[] getLogFields() throws VWException {
        VWLogElement logElement = (VWLogElement)this.m_logElements.lastElement();
        if (logElement != null) {
            return logElement.getDataFields();
        }
        return null;
    }

    public String getWorkObjectNumber() {
        return this.m_woHistory.getWorkObjectNumber();
    }

    double getFirstUniqueId() {
        return this.m_firstUniqueId;
    }

    double getLastUniqueId() {
        return this.m_lastUniqueId;
    }

    public boolean getIsSameParticipant(VWParticipantHistory participant) {
        if (participant == null) {
            return false;
        }
        return this.getWorkObjectNumber().equals(participant.getWorkObjectNumber()) && Double.compare(participant.getFirstUniqueId(), this.m_firstUniqueId) == 0;
    }

    public boolean getIsSameParticipant(VWWorkObject wob) throws VWException {
        if (wob == null) {
            return false;
        }
        if (!this.getWorkObjectNumber().equals(wob.getWorkObjectNumber())) {
            return false;
        }
        if (this.getStepStatus() != 1) {
            return false;
        }
        int woUniqueId = (int)wob.workObjectId.getUniqueID();
        VWParticipantHistory history = this.m_woHistory.getParticipant(woUniqueId);
        if (history != null) {
            return this.getIsSameParticipant(history);
        }
        return false;
    }

    public boolean getIsReminded() {
        return this.m_reminderLog != null;
    }

    public boolean getIsOverdue() {
        return this.m_overdueLog != null;
    }

    public Date getReminder() throws VWException {
        if (this.getIsReminded()) {
            return this.m_reminderLog.getTimeStamp();
        }
        return null;
    }

    public Date getOverdue() throws VWException {
        if (this.getIsOverdue()) {
            return this.m_overdueLog.getTimeStamp();
        }
        return null;
    }

    public static boolean isSystemInstructionsOperation(int operationId) {
        return operationId == 0 || operationId == 5 || operationId == 27 || operationId == 28 || operationId == 29 || operationId == 6 || operationId == 37 || operationId == 7 || operationId == 39 || operationId == 38 || operationId == 40 || operationId == 41 || operationId == 14 || operationId == 17 || operationId == 42 || operationId == 1 || operationId == 8 || operationId == 9 || operationId == 13 || operationId == 16 || operationId == 19;
    }

    protected VWSession getSession() {
        return this.m_woHistory.getSession();
    }
}

